//********************************************************************
//  Quilt2.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.26 (5E, p. 288)
//********************************************************************

import javax.swing.JApplet;
import java.awt.Color;
import java.awt.Graphics;

public class Quilt2 extends JApplet
{
   private final int MAX_ROWS = 10, MAX_COLS = 10;

   private Pattern pattern1, pattern2, currentPattern;

   //----------------------------------------------------------------
   //  Creates the pattern objects for the quilt.
   //----------------------------------------------------------------
   public void init ()
   {
      pattern1 = new Pattern (Color.yellow, Color.blue, true);
      pattern2 = new Pattern (Color.cyan, Color.red, false);

      setSize (240, 240);
      setBackground (Color.black);
   }

   //----------------------------------------------------------------
   //  Draws the quilt.
   //----------------------------------------------------------------
   public void paint (Graphics page)
   {
      for (int row=1; row <= MAX_ROWS; row++)
      {
         if (row % 2 != 0)
            currentPattern = pattern1;
    else
            currentPattern = pattern2;

         for (int col=1; col <= MAX_COLS; col++)
         {
            currentPattern.draw (page, row, col);

            if (currentPattern == pattern1)
               currentPattern = pattern2;
            else
               currentPattern = pattern1;
         }
      }
   }
}
